package com.example.tp6_02.json;


import com.example.tp6_02.dto.CityDTO;
import com.example.tp6_02.dto.WeatherConditionDTO;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonHandler {

    public static CityDTO deSerializeJson2CityDTO(String resp) {
        CityDTO city = new CityDTO();
        try {
            JSONObject mResponseObject = new JSONObject(resp);
            String cod = mResponseObject.getString("cod");
            if(cod.contains("200")) {
                city.setName(mResponseObject.getJSONObject("city").getString("name") + " - " + mResponseObject.getJSONObject("city").getString("country"));
                JSONArray array = mResponseObject.getJSONArray("list");
                for (int i = 0; i < array.length(); i++) {
                    WeatherConditionDTO day = new WeatherConditionDTO();
                    JSONObject obj1 = array.getJSONObject(i);
                    day.setDate(obj1.getString("dt_txt"));
                    day.setMax((int) obj1.getJSONObject("main").getDouble("temp_max"));
                    day.setMin((int) obj1.getJSONObject("main").getDouble("temp_min"));
                    JSONArray array2 = obj1.getJSONArray("weather");
                    for (int j = 0; j < array2.length(); j++) {
                        JSONObject obj2 = array2.getJSONObject(j);
                        day.setIconUrl(obj2.getString("icon"));
                    }
                    city.addWeather(day);
                }
                return city;
            }
            else{
                return null;
            }
        }
        catch (Exception ee){
                // if we have a problem, simply return null
                return null;
        }

    }

}
